.H 1 Introduction
Welcome to rtpi!
Rtpi is a window-based interactive debugger
for distributed real-time systems constructed from a 
heterogeneous mixture of processors and operating systems.
It provides a network of windows for each program it controls,
allowing C, C++, and assembler programs to be examined
from different perspectives.
.P
This Help window provides detailed descriptions of rtpi's user interface,
window types, window layout, and mouse and keyboard operators.
New users should read the "OpenLook Interface" and "Window Types"
sections first, and then the window descriptions, as needed.
Topics of interest may be displayed several ways:
.AL 1
.LI
For the description of a window and its operators,
select entries in the "help" sub-menu that is available in the
"edit" menu in every window's menu bar.
.LI
Select text in any window (except the Keyboard Input window)
and type the character "?" followed by a carriage return.
This scrolls the Help window to the description of the
current keyboard language.
.LI
Select entries in the "topics" pop-up window that is available in
the Help window's menu bar.
.LE
.H 2 "Rtpi Features"
Rtpi debugs all levels of the software, from the lowest level
start-up code and interrupt handlers in operating system kernels
to application programs, with a consistent user interface.
The same user interface may also be used to debug processes running
under the Unix operating system with pi.
.P
Rtpi can concurrently debug all of the software in a system.
If a system contains multiple processors,
a separate view for each processor may be opened.
If a processor runs an operating system that supports multiple processes,
each process may be opened.
When operating system kernels are debugged, both the operating
system kernel and the applications may be debugged concurrently.
.P
The system automatically configures itself to the number of processors,
processor types, and operating systems.
Windows appropriate for the configuration are created when a system is opened.
.P
Rtpi may spy on C expressions and memory locations
without stopping a program, allowing real-time applications to
be monitored with minimal impact on the program's timing.
.P
Rtpi may attach to running programs, allowing errors that are
difficult to reproduce or that only occur after the programs
runs correctly for long periods of time to be located in programs
that were not started in any special manner.
.P
No specialized hardware or emulators are needed.
.H 2 "Debug Agents"
Rtpi uses debug agents to hide the details of accessing the
hardware on the target systems.
An agent may be a Unix process running on the same processor as rtpi
or part of the software running on a target.
For example, rtpi may be used with a new device driver
by simply writing a Unix process that forwards the debugging requests.
Rtpi only needs to be modified when support for
new types of processors or operating systems are added.
.P
Each debug agent provides rtpi with a set of primitives that allow
programs to be controlled.
An agent may control multiple, heterogeneous processors - the
processors may have different architectures and operating systems.
With multi-tasking operating systems the agent may allow each process
to be controlled separately.
An agent is free to forward the requests to other processors in a system.
For example, in multi-processor systems an agent running on one
processor usually manages the communications channel with rtpi and
redistributes the requests to cooperating agents on each
processor in the system.
.P
The protocol between rtpi and the debug agents is
designed to keep the agents simple since they often run in
environments with sparse run-time support.
All requests originate from rtpi and return a confirmation that
the request was accepted, along with any transferred data.
Each request has a processor and process id field for
multi-processor and multi-tasking operating systems.
Rtpi concurrently debugs multiple processes by polling them in sequence
so only primitives that don't block rtpi for long periods are allowed.
For example, a primitive that returns the status of a program is allowed,
while one that waits until a breakpoint is hit is not,
as it may block indefinitely.
.P
When a connection to an agent is made rtpi determines the number and
names of available processors and displays them in a new window.
From that window the processors may be opened.
When a processor is opened the processor's type and operating system
are determined and a C++ class is instantiated that is compatible
with the target's debug primitives.
The instantiated class creates a suitable set of windows.
.H 2 "Supported Environments"
Rtpi supports a simple debug monitor that controls a single program,
a real-time multi-tasking executive, and targets running the Unix
operating system.
The debug monitor runs on MC680X0, WE32100, and DSP32C targets
and the same debugging protocol has been used to debug applications
running in a DSP32C chip simulator.
The debug monitor requires minimal resources on the target system:
a communications channel to the host and the ability to single step
the processor and service breakpoints are all that is required.
The debug monitor also provides interfaces to forward requests in
multi-processor systems and to debug operating system kernels.
It has been used to debug embedded real-time applications,
a multi-tasking real-time executive (NRTX), and Unix operating system kernels.
.P
The real-time multi-tasking real-time executive NRTX runs on 680X0 targets.
A separate hierarchy of windows may be opened for each NRTX process and
a communications channel into the debug monitor allows the NRTX kernel to be 
concurrently debugged with its applications.
.P
Rtpi also permits remote debugging of processes running
under the Unix operating system.
A small debug agent process runs on the target and the bulk of the work,
such as parsing and manipulation of the symbol table and source files,
is performed locally.
Designed primarily as a tool for porting pi to new architectures,
this feature allows rtpi to control multiple target Unix systems,
each running a different version of the Unix operating system
and having a different architecture.
Remote debugging works with Sun-3, SPARC, and Silicon Graphics workstations,
and 80[34]86 based PCs.
.H 2 "Starting Rtpi"
To start rtpi, place the directory where it is installed on your PATH and type:
.DS I N
pi &
.DE
.P
On start-up, rtpi starts pads, its companion user interface process,
and creates two windows on the screen:
the Unix Pi window and the Keyboard Input window.
These windows are described in the "Unix Pi Window"
and "Keyboard Input Window" sections.
The default window layouts, fonts, and colors are determined by X
resources (see "X Resources").
.H 2 "Pads"
Rtpi is implemented with two processes, rtpi and pads,
that are connected to each
other with a bidirectional pipe (Unix domain socket).
Pads is a C program that provides the user interface and manages
the display, keyboard and mouse.
Rtpi, the debugger, is a C++ program that does everything else: it controls
processes using the debug primitives provide by agents on the target systems,
manages the symbol table and source files, and executes the operators
selected in the menus or entered from the keyboard.
The user interface is separated from the debugger for several reasons:
.AL 1
.LI
Pads can be customized to run in different windowing environments
without having to modify the debugger.
.LI
Pads is responsive to user requests, such as popping up menus,
even when pi is busy performing complex operations.
.LI
Rtpi and pads may execute on different machines.
When debugging remotely, the network traffic between rtpi and pads
is much less than the network traffic between pads and the X server.
In addition, pads may be used to to debug programs remotely with
window systems that do not support network connections.
.LE
.H 2 "Remote Execution"
You have two options for running the OpenLook version
of rtpi on a remote machine.
.AL 1
.LI
Run both rtpi and pads on the remote machine and use X's networking
facilities to connect to the local display.
On the local machine enable X connections from the remote system with the
xhost command, and on the remote system set the X11 environment
variable DISPLAY to the name of the local display before rtpi is started.
For example, if the hostname of the workstation running the X server
is daksun and the remote machine's hostname is integral:
.DS I N
daksun% xhost +integral
integral being added to access control list
daksun% rlogin integral
integral% DISPLAY=daksun:0
integral% export DISPLAY
integral% rtpi &
.DE
.LI
Run pads locally and pi on the remote machine.
This will result in much less Ethernet traffic.
To do this, the directory containing the pi binary on the remote
system should be set in the JTOOLSBIN environment variable,
and pi should be invoked with the -r option on the local machine.
For example, if the pi binary resides in the directory /usr/local/bin
on the remote machine named integral:
.DS I N
daksun% JTOOLSBIN=/usr/local/bin
daksun% export JTOOLSBIN
daksun% rtpi -r integral &
.DE
.P
If the JTOOLSBIN environment variable is not set rtpi assumes
that the rtpi binary resides in the directory /usr/jtools/bin
on the remote system.
.LE
.H 2 "Compiling"
Programs that are going to be debugged with pi should
be compiled with the -g option.
If Sun's unbundled compiler is used with SunOS 5.0 (Solaris 2.0) or later
on SPARCs, the -xs option should also be used.
These place additional symbol table information for
debugging purposes in the executable file,
such as mappings between C statements and assembly instructions,
detailed descriptions of user defined types, as well as type and location
information for functions, local and global variables, and arguments.
Only files compiled with -g will appear in the Source Files window for
a process.
On most machines, the -g option is incompatible with the -O option,
so it will not be possible to debug symbolically files compiled with
the optimizer at the source code level.
.H 2 "C++ Code"
Rtpi is a good tool for debugging C++ code, but only supports a few
C++ specific features:
.AL 1
.LI
It has a built-in C++ name de-mangler to convert the complex variable
names generated by cfront back into their original names.
The de-mangler is compatible with version 3.0 of USL C++.
.LI
Source Text windows generate special menus when several functions are
generated by a single line of source code.
These menus allow the functions to be treated individually or as a group.
Code generated by C++ templates and C++ in-line functions that are not
coded in-line use these facilities.
.LI
The "func index" menu in Source Text windows lists the argument prototypes
for C++ functions, to allow overloaded function names to be distinguished.
.LI
Rtpi's expression interpreter allows the character sequence "::" to be embedded
in identifiers.
.LE
.P
Rtpi does not have a C++ expression interpreter, and treats C++ code as C.
Even though cfront generates C structs that may be different
from the C++ classes you write, rtpi's tools for browsing through C data
structures allow you to find the correspondence between the C++ and
generated C with a minimal amount of effort. 
While a C++ expression interpreter would improve things,
rtpi does a reasonable job treating C++ code as C. 
.H 2 Distribution
This version of rtpi is proprietary to AT&T,
and should not be distributed outside
the company without permission from Department BL0112280.
Within AT&T, it may be redistributed freely.
.P
I maintain a mailing list of users for updates and propaganda.
If you would like to be added, send electronic or paper mail to:
.DS I N
	David Kapilow
	AT&T Bell Laboratories
	Room 2C-479
	600 Mountain Ave
	P. O. Box 636
	Murray Hill, N. J. 07974-0636
Phone:	(908)-582-3596
Email:	research!dak or dak@research.att.com
.DE
.P
The mail should state whether you would like to receive future
binary distributions, or just email descriptions of the new features.
Bug reports, complaints, compliments, and suggestions are also welcome.
